function y = calc_SII_analytical(ene, peak_pos, Gamma, g0_mech_cav, par)

    function y = chi_opt(w)
        y = 1/(par.opt.K/2 - 1i*(w + par.opt.det));
    end

ene = ene*2*pi;
peak_pos = peak_pos*2*pi;
Gamma = Gamma*2*pi;
g0_mech_cav = 2*pi*g0_mech_cav;

% for j=1:size(ene, 2)-1 % for g0
for j=1:size(ene, 2)
    chi_opt_p = chi_opt(ene(j));
    chi_opt_m = chi_opt(-ene(j));
    
    y(j) = par.opt.Ke/2*par.mech.nb*...
        abs(par.opt.alpha*chi_opt_p - conj(par.opt.alpha)*...
        conj(chi_opt_m)).^2.*...
        sum(sum(Gamma.*g0_mech_cav.^2./((ene(j) ...
        - peak_pos).^2 + (Gamma./2).^2)));
    y(j) = y(j)*2; % modes at +k and -k

end
% y(size(ene, 2)) = y(size(ene, 2)-1);

end